// example showing how to re-route stdout, sford

#include "mbed.h"
#include "TextLCD.h"

Serial pc(USBTX, USBRX, "hi");
TextLCD lcd(p10, p11, p12, p15, p16, p29, p30, "lcd"); // rs, rw, e, d0-d3, name
LocalFileSystem local("local");

int main() {
    // printf to specific peripherals
    pc.printf("Hello World!\n");
    lcd.printf("Hello World!\n");

    // printf to stdout
    printf("Hello USB Serial World!\n");
    
    // change stdout to file
    freopen("/local/output.txt", "w", stdout);
    printf("Hello FileSystem World!\n");
    fclose(stdout);
    
    // change stdout to LCD
    freopen("/lcd", "w", stdout);
    printf("Hello LCD World!\n");
    fclose(stdout);

    wait(5);    

    pc.printf("Hello World!\n");
    lcd.printf("Hello World!\n");
}
