// See when the rx UART looses framing based on baudrate shmoo, sford
// connect p13 to p10

#include "mbed.h"

Serial device(p13, NC);
Serial m(NC, p10);

int main() {
    m.baud(4800);
    m.format(8, Serial::Even, 1);
    device.format(8, Serial::Even, 1);

    for(int baud_rate=4800; baud_rate>=4000; baud_rate -= 25) {
        device.baud(baud_rate);
        device.printf("Hello world! How are you today! Hello world! How are you today!\n");

        wait(0.05);

        int frame_error = (LPC_UART3->LSR >> 3) & 1;
        m.getc();  

        printf("baud_rate: %d, frame_error: %d\n", baud_rate, frame_error);
    }
}
