#include "mbed.h"

DigitalOut myled(LED1);

Serial s(p9, p10);

int main() {

    // setup the baudrate to 4800
    s.baud(4800);

    // extract the resulting divider values that were setup   
   
    LPC_UART3->LCR |= (1 << 7);     // set LCR[DLAB] to get access to dividers
    int dlm = LPC_UART3->DLM;
    int dll = LPC_UART3->DLL;
    int div = LPC_UART3->FDR & 0xF;
    int mul = LPC_UART3->FDR >> 4;
    LPC_UART3->LCR &= ~(1 << 7);    // clear LCR[DLAB]

    int pclk = 96000000;

    // from LPC1768 User Manual, 14.4.12 :
    float baudrate = pclk / (16.0 * (float)(256 * dlm + dll) * (1.0 + ((float)div / (float)mul)));
    
    printf("dlm = %d, dll = %d, div = %d, mul = %d\n", dlm, dll, div, mul);
    printf("baudrate = %f\n", baudrate);
}
