// test example for \n \r, sford
// serial loop back - wire p9 to p10

#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial loopback(p9, p10);

// read characters from serial port
void dump() {
    wait(0.1);                   // dumb wait to ensure all chars arrived
    while(loopback.readable()) { // work through chars
        char c = loopback.getc();
        if(c == '\n') {
            printf("0x%02X LF\n", c);
        } else if(c == '\r') {
            printf("0x%02X CR\n", c);
        } else {
            printf("0x%02X %c\n", c, c);
        }
    }
}

int main() {
    loopback.putc('a');
    dump();
    loopback.putc('\n');
    dump();
    loopback.putc('\r');
    dump();
    loopback.printf("hi\n");
    dump();
}
