#ifndef PS2KBD_H
#define PS2KBD_H

#include "mbed.h"

class PS2Kbd  {

public:

    PS2Kbd(PinName clk, PinName din);
    unsigned char rd(void);
    void wr(unsigned char);
    
protected:
    DigitalInOut _ps2clk;
    DigitalInOut _ps2din;

};


static const unsigned char ps2KeyMap[] = {
//   0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '`', ' ', // 00-0F
    ' ', ' ', 0x12, ' ', ' ', 'q', '1', ' ', ' ', ' ', 'z', 's', 'a', 'w', '2', ' ', // 10-1F
    ' ', 'c', 'x', 'd', 'e', '4', '3', ' ', ' ', ' ', 'v', 'f', 't', 'r', '5', ' ', // 20-2F
    ' ', 'n', 'b', 'h', 'g', 'y', '6', ' ', ' ', ' ', 'm', 'j', 'u', '7', '8', ' ', // 30-3F
    ' ', ',', 'k', 'i', 'o', '0', '9', ' ', ' ', '.', '/', 'l', ';', 'p', '-', ' ', // 40-4F
    ' ', ' ','\'', ' ', '[', '=', ' ', ' ', 0x58, 0x59, 0x5A, ']', ' ','\\', ' ', ' ', // 50-5F
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '1', ' ', '4', '7', ' ', ' ', '1', // 60-6F
    '0', '.', '2', '5', '6', '8', 0x1B, 0x80, ' ', '+', '3', '-', '*', '9', ' ', ' ', // 70-7F
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', // 80-8F
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', // 90-9F
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', // A0-AF
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', // B0-BF
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', // C0-CF
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', // D0-DF
    0xE0, ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', // E0-EF
    NULL, ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', // F0-FF
};

#endif