/* mbed MobileLCD (Sparkfun Nokia) Display Library
 * Copyright (c) 2007-2009 sford
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * Implements a Graphics display on the Nokia LCD from sparkfun
 */

#ifndef MBED_MOBILELCD_H
#define MBED_MOBILELCD_H

// example of simplest vs. more performant port
//  if not defined, only pixel() is implemented (slower, but simpler implementation)
//  if defined, window() and putp() are also specialised, as well as pixel()
#define MBED_MOBILELCD_FASTER
 
#include "GraphicsDisplay.h"

class MobileLCD : public GraphicsDisplay {

public:

	MobileLCD(PinName mosi, PinName sclk, PinName cs, PinName rst);

    virtual void pixel(int x, int y, int colour);
    virtual int width();
    virtual int height();

#ifdef MBED_MOBILELCD_FASTER
    virtual void window(int x, int y, int w, int h);
    virtual void putp(int colour);
#endif
    
protected:

 	void command(int value);
 	void data(int value);
 	  	
	SPI _spi;
	DigitalOut _cs;	
	DigitalOut _rst;
	
};

#endif
