/* mbed TextDisplay Display Library Base Class
 * Copyright (c) 2007-2009 sford
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * A common base class for Text displays
 * To port a new display, derive from this class and implement
 * the constructor (setup the display), character (put a character
 * at a location), rows and columns functions. Everything else
 * (locate, printf, putc, cls) will come for free
 */

#ifndef MBED_TEXTDISPLAY_H
#define MBED_TEXTDISPLAY_H

#include "mbed.h"

class TextDisplay : public Stream {
public:

    // functions to implement in derived class
    TextDisplay();
    virtual void character(int column, int row, int c) = 0;
    virtual int rows() = 0;
    virtual int columns() = 0;
    
    virtual void cls();
    virtual void locate(int column, int row);
    virtual void foreground(int colour);
    virtual void background(int colour);
    // putc, printf also available from Stream
    
protected:

    virtual int _putc(int value);
    virtual int _getc();

    // character location
    short _column;
    short _row;

    // colours
    int _foreground;
    int _background;
};

#endif
