/* mbed Terminal TextDisplay Library
 * Copyright (c) 2007-2009 sford
 * Released under the MIT License: http://mbed.org/license/mit
 */
 
#include "Terminal.h"

#include "mbed.h"

Terminal::Terminal(PinName tx, PinName rx) : _serial(tx, rx) {
    cls();
}

void Terminal::character(int column, int row, int c) {
    // Cursor Home	<ESC>[{ROW};{COLUMN}H 
	_serial.printf("\033[%d;%dH%c", row + 1, column + 1, c);
}

int Terminal::columns() {
    return 80;
}

int Terminal::rows() { 
    return 35; 
}

void Terminal::cls() {
    _serial.printf("\033[2J");
}

void Terminal::foreground(int colour) {

	/* Set Attribute Mode	<ESC>[{n}m
	 * - Sets display attribute settings. The following lists standard attributes:
	 * 
   	 * Foreground Colours
   	 * 30	Black
   	 * 31	Red
   	 * 32	Green
   	 * 33	Yellow
   	 * 34	Blue
   	 * 35	Magenta
   	 * 36	Cyan
   	 * 37	White
   	 */
   	 int r = (colour >> 23) & 1;
   	 int g = (colour >> 15) & 1;
   	 int b = (colour >> 7) & 1;
   	 int bgr = (b << 2) | (g << 1) | (r << 0);
   	 int c = 30 + bgr;
    _serial.printf("\033[%dm", c);
}

void Terminal::background(int colour) {
	  
   	 /* Background Colours
   	 * 40	Black
   	 * 41	Red
   	 * 42	Green
   	 * 43	Yellow
   	 * 44	Blue
   	 * 45	Magenta
   	 * 46	Cyan
   	 * 47	White
	 */
   	 int r = (colour >> 23) & 1;
   	 int g = (colour >> 15) & 1;
   	 int b = (colour >> 7) & 1;
   	 int bgr = (b << 2) | (g << 1) | (r << 0);
   	 int c = 40 + bgr;
     _serial.printf("\033[%dm", c);
}
 