/* mbed MobileLCD (Sparkfun Nokia) Display Library
 * Copyright (c) 2007-2009 sford
 * Released under the MIT License: http://mbed.org/license/mit
 */
  
#include "MobileLCD.h"

MobileLCD::MobileLCD(PinName mosi, PinName sclk, PinName cs, PinName rst) : _spi(mosi, NC, sclk), _cs(cs), _rst(rst) {
    _cs = 1;
    _rst = 0;
    _spi.format(9);
    _spi.frequency(5000000);
    wait(0.001);
    _rst = 1;
    wait(0.001);
    _cs = 0;

    command(0xCA); // display control 
    data(0);
    data(32);
    data(0);

    command(0xBB); 
    data(1);

    command(0xD1); // oscillator on
    command(0x94); // sleep out
    command(0x20); // power control
    data(0x0F);

    command(0xA7); // invert display
    command(0x81); // Voltage control
    data(39);      // contrast setting: 0..63
    data(3);       // resistance ratio
    wait(0.001);

	command(0xBC); // data control
  	data(3); // scan dirs 
  	data(1); // RGB
  	data(4); // grayscale   	  	
  	
    command(0xAF);  // turn on the display   
	_cs = 1;
	
	cls();
}

void MobileLCD::pixel(int x, int y, int colour) {
    _cs = 0;
    
	command(0x15); // column
	data(2 + x);       
	data(2 + x); 
	command(0x75); // page
  	data(y);            
  	data(y);
   	command(0x5C); // start write to ram

	int gr = ((colour >> 20) & 0x0F)
	       | ((colour >> 8 ) & 0xF0);
	int nb = ((colour >> 4 ) & 0x0F);
	data(nb); 
	data(gr);
	
	_cs = 1; 
}
 	
int MobileLCD::width() { return 130; }
int MobileLCD::height() { return 130; }
 	
void MobileLCD::command(int value) {
	_spi.write(value & 0xFF);
}

void MobileLCD::data(int value) {
	_spi.write(value | 0x100);
}

#ifdef MBED_MOBILELCD_FASTER
void MobileLCD::window(int x, int y, int w, int h) {
    _cs = 0;
	command(0x15); // column
	data(2 + x);       
	data(2 + x + w - 1); 
	command(0x75); // page
  	data(y);            
  	data(y + h - 1);
   	command(0x5C); // start write to ram
    _cs = 1;
}

void MobileLCD::putp(int colour) {
    _cs = 0;
   	int gr = ((colour >> 20) & 0x0F)
	       | ((colour >> 8 ) & 0xF0);
	int nb = ((colour >> 4 ) & 0x0F);
	data(nb); 
	data(gr);
	_cs = 1; 
}

#endif
