/* mbed Embedded Artists QVGA LCD Display Library
 * Copyright (c) 2007-2009 sford
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * Implements a QVGA LCD display from Embedded Artisits
 */

#ifndef MBED_EA_QVGALCD_H
#define MBED_EA_QVGALCD_H
 
#include "GraphicsDisplay.h"

class EA_QVGALCD : public GraphicsDisplay {

public:

    EA_QVGALCD(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName rst);

    virtual void pixel(int x, int y, int colour);
    virtual int width();
    virtual int height();
    virtual void window(int x, int y, int w, int h);
    virtual void putp(int colour);
    
protected:

     void command(int value);
     void data(int value);
    void config(int index, int value);
           
    SPI _spi;
    DigitalOut _cs;    
    DigitalOut _rst;
    
};

#endif
