// mean and median averaging examples, sford

#include "mbed.h"

AnalogIn input(p20);

int compare(const void *a, const void *b) {
    return (int)(*(float*)a - *(float*)b);
}

float median(float *samples, int n) {
    qsort(samples, n, sizeof(float), compare);
    if(n % 2) { // odd number of samples
        return samples[(n - 1)/2];
    } else {    // even number of samples
        return (samples[(n/2)-1] + samples[n/2]) / 2.0;
    }
}

float mean(float *samples, int n) {
    float sum = 0.0;
    for (int i=0; i<n; i++) {
        sum += samples[i];
    }
    return sum / (float)n;
}

int main() {

    float samples[9];

    // take some samples
    for(int i=0; i<9; i++) {
        samples[i] = input;
        wait(0.01);
    }

    // show the samples
    for(int i=0; i<9; i++) {
        printf("%f\n", samples[i]);
    }
    
    // show the averages
    printf("mean = %f\n", mean(samples, 9));
    printf("median = %f\n", median(samples, 9));
}
