// Drums via MIDI!
#include "mbed.h"
#include "USBMIDI.h"

DigitalOut drum[] = {p5, p6, p7, p8}; // the four outputs

void drums(int id, bool on) {
    if(id >= 0 && id <= 3) {
        drum[id] = on;
    }
}

void do_message(MIDIMessage msg) {
    switch (msg.type()) {
        case MIDIMessage::NoteOnType:
            drums(msg.key() - 64, msg.velocity() != 0);
            break;
        case MIDIMessage::NoteOffType:
            drums(msg.key() - 64, 0);
            break;
    }    
}

USBMIDI midi;

int main() {          
    midi.attach(do_message);         // call back for messages received    
    while (1);
}
