#include "mbed.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"
EthernetNetIf eth;
UDPSocket     cfgSocket;

void onUDPSocketEvent(UDPSocketEvent e) {
    if ( e == UDPSOCKET_READABLE ) {
        char buf[64] = {0};
        Host host;
        while ( int len = cfgSocket.recvfrom( buf, 63, &host ) ) {
            if ( len <= 0 )
                break;
            printf("From %d.%d.%d.%d: %s\n", host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3], buf);
        }
    }
}

int main() {
//   pc.baud(115200);
    printf ("HEllo World - 7 *\n");

    EthernetErr ethErr = eth.setup();
    if ( ethErr == ETH_OK ) {
        IpAddr ip = eth.getIp();
        printf("mbed IP Address is %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]);
    } else printf ("ETHERNETSETUP FAILED\n");

    printf("seting event\n");
    cfgSocket.setOnEvent(&onUDPSocketEvent);
    printf("seting host\n");
    Host x(IpAddr(),5555);
    printf("seting bind\n");

    UDPSocketErr udpErr = cfgSocket.bind( x );
    if ( udpErr != UDPSOCKET_OK )
        printf("error %d\n", udpErr);

    int i = 0;
    Host brdHost(IpAddr(255,255,255,255), 5555);                    //broadcast test msg
    char cfgRqstMsg[]="SERVER CONFIG REQUEST";

    Timer tmr;
    tmr.start();
    while (1) {
        Net::poll();
        if ( tmr.read() > 5) {
            tmr.reset();
            int nSent = cfgSocket.sendto(cfgRqstMsg,strlen(cfgRqstMsg),&brdHost);
            printf("PLONKER %d :: %d\n",++i,nSent);
            if ( nSent < 0 )
                printf("error %d\n", (UDPSocketErr)nSent);
        }
    }
}