// Twittering Billy Bass demo example
// Hack billy to read out samples and fetch twitters
// Based on Steve Ravet's original Billy Bass hack

#include "mbed.h"

#include "MSCFileSystem.h"
#include "billy.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

// Network and USB filesystem
EthernetNetIf eth;
HTTPClient http;
MSCFileSystem usb("usb");

DigitalOut setup_led(LED1);
DigitalOut waiting_led(LED2);
DigitalOut downloading_led(LED3);
DigitalOut button_led(LED4);

// Simple HTTP helper functions
int get_file(char *url, char *file) {
    printf("Getting url to file [%s]...\n", url);
    HTTPFile f(file);
    HTTPResult r = http.get(url, &f);
    if (r != HTTP_OK) {
        printf("HTTPResult error %d\n", r);
        return 0;
    }
    return 1;
}

int get_string(char *url, char *str) {
    printf("Getting url [%s] to string...\n", url);
    HTTPText t;
    HTTPResult r = http.get(url, &t);
    if (r != HTTP_OK) {
        printf("HTTPResult error %d\n", r);
        str[0] = 0;
        return 0;
    }
    strcpy(str, t.gets());
    return 1;
}

// a url to poll that returns the id of newest message
int billy_get_id(char *id) {
    return get_string("http://example.com/billy/billy.py", id);
}

// downloads a wav file with specific id to the usb disk
int billy_get_wav(char *id) {
    char url[128];
    sprintf(url, "http://example.com/billydata/%s.wav", id);
    return get_file(url, "/usb/download.wav");
}

// downloads a movement file with specific id to the usb disk
int billy_get_mov(char *id) {
    char url[128];
    sprintf(url, "http://example.com/billydata/%s.txt", id);
    return get_file(url, "/usb/download.txt");
}

// see if there is a new message, and download it if so
int billy_get_new_message() {
    static char last[64] = {0};
    char id[64];
    billy_get_id(id);
    if (strcmp(last, id) != 0) { // new message
        printf("New message found...\n");
        downloading_led = 1;
        billy_get_wav(id);
        billy_get_mov(id);
        strcpy(last, id);
        downloading_led = 0;
        return 1;
    }
    return 0;
}

// pre-programmed songs on the USB disk
const char *songs[] = {"baddonut", "belcher", "people", "clinton", "coconut", "bushfool", "ecky", "ni", "looney", "lumber"};
int nsongs = 10;

// play the next pre-programmed song in the list
void billy_play_next() {
    static int n = 0;
    char wavname[64];
    char cmdname[64];
    sprintf(wavname, "/usb/%s.wav", songs[n]);
    sprintf(cmdname, "/usb/%s.txt", songs[n]);
    n = (n + 1) % nsongs;
    billy_play(wavname, cmdname);
}

// capture button presses
InterruptIn button(p24);
void button_press() {
    if(button) {    // minor debounce
        button_led = 1;
    }
}

// main billy loop, looking for tweets and button presses
int main() {
    printf("Twittering billy...\n");

    printf("Setup network...\n");
    setup_led = 1;
    EthernetErr ethErr = eth.setup();
    if(ethErr) {
        printf("Error %d in setup\n", ethErr);
        setup_led = 0;
    } 

    button.rise(&button_press); // look out for button presses

    while (1) {
        waiting_led = !waiting_led;
        
        if(setup_led) {                                                 // if we have network
            if(billy_get_new_message()) {                               // see if there is a new message
                billy_play("/usb/download.wav", "/usb/download.txt");   // and play it if so
            }
        }
        
        if(button_led) {        // if the button has been pressed
            billy_play_next();  // play the next song
            button_led = 0;
        }

        wait(1);
    }
}

