// Write to all HD44780 TextLCD RAM locations, sford
//
// A quick hack to write to all the display RAM locations
// in an HD44780 display, to identify which location maps
// to which character.
//
// Instructions:
//  - Change TextLCD pinout as appropriate so it works
//  - Run, and it should fill the screen with characters
//  - Identify what characters are at the start of each row
//
// To determine what address each line starts at, you subtract the 
// ascii code for '0'(48) from the character at the start of each line
//  - see http://www.asciitable.com/
// 
// e.g.
//   +----------------+
//   |0123456789:;<=>?| first char = '0' (48)
//   |XYZ....         | first char = 'X' (88)
//   +----------------+
//  
// So in this case, the RAM offsets are 0 and 40

#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p10, p11, p12, p15, p16, p29, p30);
DigitalOut led(LED1);

int main() {
    lcd.locate(0,0);
    for(int i=0; i<80; i++) {
        lcd._rs = 1; 
        lcd.writeByte('0' + i);
    }
}

