/* mbed Terminal TextDisplay Library
 * Copyright (c) 2007-2009 sford
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * Implementation of a TextDisplay using a VT100 Terminal and 
 * escape codes (e.g. Teraterm, Hyperterminal)
 */

#include "TextDisplay.h"

#ifndef MBED_TERMINAL_H
#define MBED_TERMINAL_H

class Terminal : public TextDisplay {
public:

    Terminal(PinName tx, PinName rx);

    virtual void character(int column, int row, int c);
    virtual int rows(); 
    virtual int columns();  

	virtual void cls();
    virtual void foreground(int colour);
    virtual void background(int colour);

protected:

    Serial _serial;
    
};

#endif
