// using 2 serial instances to workaround hand bug while using printf both inside and outside interrupt

#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
Serial pc2(USBTX, USBRX); // tx, rx

// debugging LEDs
DigitalOut interrupt(LED1);
DigitalOut tx(LED4);

void handle() {
    char rx_byte = pc2.getc();
    interrupt = !interrupt;
}

int main() {
    pc2.attach(handle);

    while (1) {
        // send a long string of bytes
        tx = 1;
        for (int i=0;i<20;i++) {
            printf("If I receive while transmitting this I will crash...\r\n");
        }
        tx = 0;
        wait(1.0);
    }
}
