// Basic example to control scratch with mbed
// Copyright (c) 2008-2009 sford
// Released under the MIT License: http://mbed.org/license/mit

#include "mbed.h"

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);

// The scratch IO
AnalogIn pin15(p15);
AnalogIn pin16(p16);
AnalogIn pin17(p17);
AnalogIn pin18(p18);
AnalogIn pin19(p19);
AnalogIn pin20(p20);
DigitalIn pin13(p13);
DigitalIn pin14(p14);

/* The format
 high byte (sent 1st)
 [ 1 | c3:0 | d9:7 ]
 low byte
 [ 0 | d6:0 ]
*/
void send(int channel, int data) {
    int high = 1 << 7
             | (channel & 0xF) << 3
             | ((data >> 7)& 0x7);
    int low = data & 0x7F;
    pc.putc(high);
    pc.putc(low);
}

int main() {
    pc.baud(38400);
    while(1) {
        pc.getc(); // wait for poll
        led1 = !led1;
        send(15, 4); // firmware
        send(0, pin20 * 1023.0);
        send(1, pin19 * 1023.0);
        send(2, pin18 * 1023.0);
        send(3, pin14 * 1023.0);
        send(4, pin17 * 1023.0);
        send(5, pin16 * 1023.0);
        send(6, pin13 * 1023.0);                                
        send(7, pin15 * 1023.0);
    }
}
