// Example running the mbed Tickers at a lower priority

#include "mbed.h"

volatile int counter = 0;
void timing_critical() {
    counter++;
}

void long_event() {
    wait_ms(50);
}

PwmOut out(p25);
InterruptIn in(p26);
Ticker tick;

int main() {
    out.period_ms(10);
    out.pulsewidth_ms(5);
    in.rise(&timing_critical);

    printf("1) InterruptIn only...\n");    
    for(int i=0; i<5; i++) {
        counter = 0;
        wait(1);
        printf("counts/sec = %d\n", counter);
    }

    tick.attach(&long_event, 0.1);    
    
    printf("2) InterruptIn plus long running occasional ticker event...\n");    
    for(int i=0; i<5; i++) {
        counter = 0;
        wait(1);
        printf("count/sec = %d\n", counter);
    }
    
    printf("3) InterruptIn plus long running occasional ticker event at lower priority...\n");    
    NVIC_SetPriority(TIMER3_IRQn, 255); // set mbed tickers to lower priority than other things
    for(int i=0; i<5; i++) {
        counter = 0;
        wait(1);
        printf("counter = %d\n", counter);
    }
}
