// Example of hanging when reading a bad pointer

#include "mbed.h"

DigitalOut myled(LED1);

int x[10] = {0};

extern "C" void HardFault_Handler() {
    error("Hit HardFault handler!\n");
}

int main() {
    int *ok_ptr = x;
    int *bad_ptr = (int*)0xe600b0; // not in RAM!
    printf("ok_ptr = 0x%08X, bad_ptr = 0x%08X\n", ok_ptr, bad_ptr);
    
    int ok_read = ok_ptr[0];
    printf("ok_read = %d\n", ok_read);
    
    int bad_read = bad_ptr[0]; 
    printf("bad_read = %d\n", bad_read);

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
