#include "mbed.h"

SPI spi(p5, p6, p7);   // mosi, miso, sclk (or "command", "data", "clock")
DigitalOut cs(p25);       // chip select (or "attention")

// setup the controller in to analog mode
void ps2_analog_mode() {
    const char enter_config_mode[5]  = {0x01, 0x43, 0x00, 0x01, 0x00};
    const char enable_analog_mode[9] = {0x01, 0x44, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00};
    const char exit_config_mode[9]   = {0x01, 0x43, 0x00, 0x00, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A};

    cs = 0;
    for (int i=0; i<5; i++) {
        spi.write(enter_config_mode[i]);
    }
    cs = 1;

    wait_us(1);

    cs = 0;
    for (int i=0; i<9; i++) {
        spi.write(enable_analog_mode[i]);
    }
    cs = 1;

    wait_us(1);

    cs = 0;
    for (int i=0; i<9; i++) {
        spi.write(exit_config_mode[i]);
    }
    cs = 1;
}

int main() {
    ps2_analog_mode();

    while (1) {
        const char poll_command[9] = {0x01, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
        char response[9];

        cs = 0;
        for (int i=0; i<9; i++) {
            response[i] = spi.write(poll_command[i]);
        }
        cs = 1;

        printf("Digital %02X %02X   Analog %02X %02X %02X %02X\n", response[3], response[4], response[5], response[6], response[7], response[8]);
    }
}

