#include "mbed.h"

int main() {
    int Fin = 12000000; // 12MHz XTAL
    
    printf("PLL Registers:\n");
    printf(" - PLL0CFG = 0x%08X\n", LPC_SC->PLL0CFG);
    printf(" - CLKCFG  = 0x%08X\n", LPC_SC->CCLKCFG);
    
    int M = (LPC_SC->PLL0CFG & 0xFFFF) + 1;
    int N = (LPC_SC->PLL0CFG >> 16) + 1;
    int CCLKDIV = LPC_SC->CCLKCFG + 1;

    printf("Clock Variables:\n");
    printf(" - Fin = %d\n", Fin);
    printf(" - M   = %d\n", M);
    printf(" - N   = %d\n", N);
    printf(" - CCLKDIV = %d\n", CCLKDIV);

    int Fcco = (2 * M * 12000000) / N;
    int CCLK = Fcco / CCLKDIV;

    printf("Clock Results:\n");    
    printf(" - Fcco = %d\n", Fcco);
    printf(" - CCLK = %d\n", CCLK);    
}
