// example code to get MAX5842 working
// Copyright (c) 2009, sford
// Released under the MIT License: http://mbed.org/license/mit

// MAX5842 setup: ADD = 0v, REF = 3.3v, OUTA -> p16

#include "mbed.h"

AnalogIn result(p16); // input to test MAX5842 output 
DigitalOut led(LED1);

I2C max5842(p9, p10);

int main() {

    max5842.frequency(400000); // 400 KHz
    
    // ADDR: 011 110 ADD, where ADD = 0 
    // 011 1100 == 0x3C
    const int addr = 0x3C;

    // Power up the DAC
    // - Extended Commands [ 1111 0000 xx DCBA PD1 PD0 ]
    // - DCBA = 1111 means select all, PD = 00 means power on
    char power_up[2] = {0xF0, 0x3C};
    max5842.write(addr, power_up, 2);
    
    // set A output to 50%
    //   0 (set A) D DD
    char data[2] = {0x08, 0x00};
    max5842.write(addr, data, 2);

    while(1) {
        printf("res = %f\n", result.read());
        led = !led;
        wait(0.25);
    }
}
