#include "mbed.h"
#include "QEI.h"
#include "Motor.h"

Serial pc(USBTX, USBRX);
QEI Encoder(p29 ,p30, NC, 48);
Motor Wheel(p23, p21, p22);

int main() {
    float MotorOutput = 0;
    Encoder.reset();
    while (1) {
        pc.scanf("%f", &MotorOutput);
        float NoPulses = Encoder.getPulses();

        float Percentage = (NoPulses / 48) * 100;
        pc.printf("%f\n", Percentage);

        Wheel.speed((MotorOutput - 50) * 2 / 100);

        wait(0.005);
    }
}
