 AREA |.data|, DATA, READWRITE
 EXPORT leds
         
;BIT MASKS FOR LED1...LED4

LED1 EQU 0x040000 
LED2 EQU 0x100000
LED3 EQU 0x200000
LED4 EQU 0x800000
ALLLEDS EQU LED1 :OR: LED2 :OR: LED3 :OR: LED4

leds DCD LED1, LED2, LED3, LED4
    
    ALIGN

 AREA    |.text|, CODE, READONLY
 EXPORT  binasm

GPIO1BASE  EQU 0x2009C020; GPIO port 1 base address
GPIOSETOFF EQU 0x18
GPIOCLROFF EQU 0x1C

binasm PROC
    PUSH {R4, LR}
    
    ; Load GPIO Port 1 base address in register R1 
    LDR     R1, =GPIO1BASE
    LDR     R4, =(leds+12) ; point to the last element of array

    ;CLEAR LEDS
    MOV   R2, #ALLLEDS
    STR   R2, [R1,#GPIOCLROFF]
    
    MOV R3, #4      ; COUNTER FOR LOOP
    ADD R0, R0, #1  ; INCREMENT PARAMETER BY 1
    
loop
    LDR  R2, [R4], #-4 ; load value from the address in R4 and decrement it by 4
    LSRS R0, R0, #1    ; shift R0 right and set carry to the shifted out bit

    STRCC   R2, [R1,#GPIOCLROFF]  ; if==0, clear LED bit
    STRCS   R2, [R1,#GPIOSETOFF]  ; if==1, set LED bit    

    SUBS R3, R3, #1
    BNE loop
    
    POP {R4, PC}
    ENDP
    
    ALIGN

    END