// a way to create incrementing filenames, sford
// every time you hit reset, will create a file with incremental filename

#include "mbed.h"

LocalFileSystem local("local");               // Create the local filesystem under the name "local"

int main() {
    char filename[64];    
    int n = 0;
    
    // set "filename" equal to the next file to write
    while(1) {
        sprintf(filename, "/local/file%03d.txt", n);    // construct the filename fileNNN.txt
        FILE *fp = fopen(filename, "r");                // try and open it
        if(fp == NULL) {                                // if not found, we're done!
            break;
        }
        fclose(fp);                                     // close the file
        n++;                                            // and try the next one
    }
    
    FILE *fp = fopen(filename, "w");
    fprintf(fp, "I am file # %d\n", n);
    fclose(fp);
}
