/* mbed ID12 RFID Library
 * Copyright (c) 2007-2011, sford, http://mbed.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

// modified to use interrupts

#include "ID12RFID.h"

#include "mbed.h"

ID12RFID::ID12RFID(PinName rx)
        : _rfid(NC, rx) {
        nbuffer = 0;
        last = 0;
        _rfid.attach(this, &ID12RFID::handler);
}

void ID12RFID::handler() {
    buffer[nbuffer] = _rfid.getc();
    if(buffer == 0) {               // waiting for '2'
        if(buffer[nbuffer] != 2) {  // is not '2'
            return;                 // so ignore
        }
    }
    nbuffer++;
    
    // 2 x x 8 chars x x x x 
    if(nbuffer > 15) {
        last = 0;
        for(int i=7; i>=0; i--) {
            char c = buffer[10 - i]; // a ascii hex char
            int part = c - '0';
            last |= part << (i * 4);
        }
        nbuffer = 0;
    }
}

int ID12RFID::readable() {
    return (last > 0); //_rfid.readable();
}

int ID12RFID::read() {
   int t = last;
   last = 0;
   return t;
}
