#include "mbed.h"

Ethernet eth;

#define NPACKETS 100000
#define NBYTES 1000

__packed struct EthPkt {  
    char   dest[6];
    char   src[6]; 
    unsigned short  type;   
};

unsigned short htons(unsigned short n) {                // Host short to network short byte swapping
    return ((n & 0xff) << 8) | ((n & 0xff00) >> 8);     
}

char data[NBYTES];





int main() {
    printf("Hello Ethernet Tx Benchmark!\n");

    // fill the data with ascending pattern, inc packet header
    for(int i=0; i<NBYTES; i++) {
        data[i] = i;
    }
    EthPkt *pkt = (EthPkt*)&data[0];
    eth.address(pkt->src);          // note, this call goes to the mbed interface, so takes a while
    for(int i = 0; i<6; i++) { 
        pkt->dest[i] = 0xFF; 
    }

    while(!eth.link());

    printf("Sending %d packets of %d bytes...\n", NPACKETS, NBYTES);

    Timer t;
    t.start();
    for(int i = 0; i < NPACKETS; i++) {
        eth.write(data, NBYTES);                     
        eth.send();                                 
    }
    t.stop();

    printf("Time = %.2f seconds\n", t.read());
    
    float bw = NPACKETS * NBYTES * 8 / t.read();
    printf("bandwidth = %.2f kbps\n", bw / 1024.0);
    
}
