#include "mbed.h"
#include "Ethernet.h"

Ethernet eth;

#define NPACKETS 100000

int main() {
    printf("Hello Ethernet Rx Benchmark!\n");

    char buffer[0x600];
    int size = 0;
    
    char buf[6] = {0};
    eth.address(buf);
    printf("mbed MAC: %02hx:%02hx:%02hx:%02hx:%02hx:%02hx\n",
            buf[0], buf[1], buf[2], buf[3], buf[4], buf[5]);    
            
    while(!eth.link());

    printf("Waiting for %d packets...\n", NPACKETS);

    Timer t;
    int n = 0;
    for(int i=0; i<NPACKETS; i++) {
        do {
            size = eth.receive();
        } while(size <= 0);
        eth.read(buffer, size);
        n += size;
    }
    t.stop();
    printf("Time = %.2f seconds\n", t.read());
    
    float bw = n * 8 / t.read();
    printf("bandwidth = %.2f kbps\n", bw / 1024.0);

}
