// example to test out OLED on mbed + XPresso baseboard, sford

#include "mbed.h"
#include "EAOLED.h"

// NOTE: The xpresso board does not provide the data/command signal to the mbed, so I added a wire:
// Connect:
//  PIO2_7 of baseboard mbed socket (empty 2nd hole below mbed pin 21)
// to
//   PIO0_8(p13) of J6 (7th hole down on left side of J6)
// to provide OLED data/command signal

EAOLED oled(p5, p6, p7, p8, p25); // mosi, dnc, sclk, cs, power

int main() {
    oled.cls();
    oled.printf("Hello World!");
    wait(1);
    oled.locate(0,5);
    oled.printf("I'm an OLED!");
    wait(1);
    for (int y=30; y<64; y++) {
        for (int x=5; x<90; x++) {
            oled.pixel(x - 4, y, 0x000000);
            oled.pixel(x + 4, y, 0xFFFFFF);
            wait(0.002);
        }
    }
    oled.locate(1,5);
    oled.printf("Bye from");
    oled.locate(1,6);
    oled.printf("mbed.org");
}
