// test library for Embedded Artists OLED used on Xpresso Baseboard

#ifndef MBED_EAOLED_H
#define MBED_EAOLED_H

#include "mbed.h"
#include "GraphicsDisplay.h"

class EAOLED : public GraphicsDisplay {
public:
    EAOLED(PinName mosi, PinName dnc, PinName sclk, PinName cs, PinName power);
    virtual void pixel(int x, int y, int colour);
  //  virtual void cls();
    virtual int width() { return 96; }
    virtual int height() { return 64; }
    
    void reset();
    void data(int value);
    void command(int value);

    SPI _spi;
    DigitalOut _data;
    DigitalOut _cs;
    DigitalOut _power;
    
    uint8_t framebuffer[(96 * 64) / 8];
};

#endif
