// test library for Embedded Artists OLED used on Xpresso Baseboard

#include "EAOLED.h"
#include "mbed.h"

EAOLED::EAOLED(PinName mosi, PinName dnc, PinName sclk, PinName cs, PinName power) 
    : _spi(mosi, NC, sclk), _data(dnc), _cs(cs), _power(power) {
    reset();    
}
      
void EAOLED::command(int value) {
    _data = 0;
    _cs = 0;
    _spi.write(value);
    _cs = 1;
}

void EAOLED::data(int value) {
    _data = 1;
    _cs = 0;
    _spi.write(value);
    _cs = 1;
}

void EAOLED::reset() {
    _power = 0;
    _cs = 1;

    // Startup sequence recommended by embedded artists baseboard reference code
    command(0x02); // set low column address
    command(0x12); // set high column address
    command(0x40); // display start set
    command(0x2e); // stop horzontal scroll
    command(0x81); // set contrast control register
    command(0x32); //
    command(0x82); // brightness for color banks
    command(0x80); // display on
    command(0xa1); // set segment re-map
    command(0xa6); // set normal/inverse display
    command(0xa8); // set multiplex ratio
    command(0x3F); //
    command(0xd3); // set display offset
    command(0x40); //
    command(0xad); // set dc-dc on/off
    command(0x8E); //
    command(0xc8); // set com output scan direction
    command(0xd5); // set display clock divide ratio/oscillator/frequency
    command(0xf0); //
    command(0xd8); // set area color mode on/off & low power display mode 
    command(0x05); //
    command(0xd9); // set pre-charge period
    command(0xF1); //
    command(0xda); // set com pins hardware configuration
    command(0x12); //
    command(0xdb); // set vcom deselect level
    command(0x34); //
    command(0x91); // set look up table for area color 
    command(0x3f); //
    command(0x3f); //
    command(0x3f); //
    command(0x3f); //
    command(0xaf); // display on
    command(0xa4); // display on

    wait_us(10);

    _power = 1;
}

#define OLED_DISPLAY_WIDTH  96
#define OLED_DISPLAY_HEIGHT 64

void EAOLED::pixel(int x, int y, int colour) {
    int page = y >> 3;
    int address = 18 + x;
    
    int lo = (address >> 0) & 0x0F;
    int hi =  (address >> 4) | 0x10;
    int mask = 1 << (y & 0x7);
    int byte = page * OLED_DISPLAY_WIDTH + x;
    
    if(colour) {
        framebuffer[byte] |= mask;
    } else {
        framebuffer[byte] &= ~mask;
    }

    command(0xB0 + page);
    command(lo);
    command(hi);
    data(framebuffer[byte]);
}

/*void EAOLED::cls() {
    for(int y=0; y<64; y++) {
        for (int x=0; x<96; x++) {
            pixel(x, y, 0xFFFFFF);
        }
    }
}*/

