/* mbed Embedded Artists OLED library, as found on the LPCXpresso Baseboard
 * Copyright (c) 2010, sford
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#ifndef MBED_EAOLED_H
#define MBED_EAOLED_H

#include "mbed.h"
#include "GraphicsDisplay.h"

class EAOLED : public GraphicsDisplay {
public:
    EAOLED(PinName mosi, PinName dnc, PinName sclk, PinName cs, PinName power);
    virtual void pixel(int x, int y, int colour);
  //  virtual void cls();
    virtual int width() { return 96; }
    virtual int height() { return 64; }
    
    void reset();
    void data(int value);
    void command(int value);

    SPI _spi;
    DigitalOut _data;
    DigitalOut _cs;
    DigitalOut _power;
    
    uint8_t framebuffer[(96 * 64) / 8];
};

#endif
