// drum machine sequenced by text file, sford
// e.g. line contains -o--, where o is a hit

#include "mbed.h"

class Drum {
public:
    Drum(PinName p) : x(p) {}
    
    void off() { x = 0; }
    void hit() { 
        x = 1;
        t.attach(this, &Drum::off, 0.01);
    }
        
    DigitalOut x;
    Timeout t;
};

Drum drums[4] = {p21, p22, p23, p24};
AnalogIn speed(p20);
BusOut leds(LED1, LED2, LED3, LED4);

LocalFileSystem local("local");

int main() {
    int count = 0;
    while(1) {
        FILE *fp = fopen("/local/drums.txt", "r");
        if(!fp) {
            error("Couldn't open file\n");
        }
        char tracks[4];
        while(!feof(fp)) {
            fscanf(fp, "%c%c%c%c\n", &tracks[0], &tracks[1], &tracks[2], &tracks[3]);
            for(int i=0; i<4; i++) {
                if(tracks[i] == 'o') {
                    drums[i].hit();
                }
            }       
            leds = 1 << (count % 4);
            count++;
            wait(0.05 + speed);            
        }
        count = 0;
        fclose(fp);
    }
}
