// AnalogIn reading 16-bit samples

#include "mbed.h"

AnalogIn input(p20);
DigitalOut led1(LED1);

int main() {
    unsigned short samples[1024];

    for(int i=0; i<1024; i++) {
        samples[i] = input.read_u16();
        wait_ms(1);
    }

    printf("Results:\n");
    for(int i=0; i<1024; i++) {
        if (samples[i] > 0x100) {
            printf("%d, 0x%04X\n", i, samples[i]);
        }
    }
}   