//
// The SKPang board has a joystick wired to pins 21 to 25.
// This is my first go at using BusIn to read multiple pins as a bus.
// My biggest surprise is that the pins are high all the time unless the joysick goes left, right, up, down, click
// at which time each goes low.
// The text output goes to the serial out, if it is running, and the Mbed internal leds represent:
//  1 = left
//  2 = up
//  3 = down
//  4 = right
//  all = click
//
#include "mbed.h"

BusIn joystick(p21, p22, p23, p24, p25);
Timer mytimer;
DigitalOut myledLeft(LED1);
DigitalOut myledUp(LED2);
DigitalOut myledDown(LED3);
DigitalOut myledRight(LED4);

int main() {
     mytimer.start();
    
     int intStart = mytimer.read_ms();
     while(1) {
         if((mytimer.read_ms() - intStart) >= 250)
         {
            myledLeft = 0;
            myledUp = 0;
            myledDown = 0;
            myledRight = 0;
            intStart = mytimer.read_ms();
            switch(joystick) {
                case 0x00: 
                    printf("0x00\r\n"); 
                    break;
                case 0x01: 
                    printf("0x01\r\n"); 
                    break;
                case 0x02: 
                    printf("0x02\r\n"); 
                    break;
                case 0x03: 
                    printf("0x03\r\n"); 
                    break;
                case 0x04: 
                    printf("0x04\r\n"); 
                    break;
                case 0x05: 
                    printf("0x05\r\n"); 
                    break;
                case 0x06: 
                    printf("0x06\r\n"); 
                    break;
                case 0x07: 
                    printf("0x07 Up and Left\r\n"); 
                    myledUp = 1;
                    myledLeft = 1;
                    break;
                case 0x08: 
                    printf("0x08\r\n"); 
                    break;
                case 0x09: 
                    printf("0x09\r\n"); 
                    break;
                case 0x0a: 
                    printf("0x0a\r\n"); 
                    break;
                case 0x0b: 
                    printf("0x0b\r\n"); 
                    break;
                case 0x0c: 
                    printf("0x0c\r\n"); 
                    break;
                case 0x0d: 
                    printf("0x0d Up and Right\r\n"); 
                    myledUp = 1;
                    myledRight = 1;
                    break;
                case 0x0e: 
                    printf("0x0e\r\n"); 
                    break;
                case 0x0f: 
                    printf("0x0f Up\r\n"); 
                    myledUp = 1;
                    break;
                case 0x10: 
                    printf("0x10\r\n"); 
                    break;
                case 0x11: 
                    printf("0x11\r\n"); 
                    break;
                case 0x12: 
                    printf("0x12\r\n"); 
                    break;
                case 0x13: 
                    printf("0x13 Down and Left\r\n"); 
                    myledDown = 1;
                    myledLeft = 1;
                    break;
                case 0x14: 
                    printf("0x14\r\n"); 
                    break;
                case 0x15: 
                    printf("0x15\r\n"); 
                    break;
                case 0x16: 
                    printf("0x16\r\n"); 
                    break;
                case 0x17: 
                    printf("0x17 Left\r\n"); 
                    myledLeft = 1;
                    break;
                case 0x18: 
                    printf("0x18\r\n"); 
                    break;
                case 0x19: 
                    printf("0x19 Down and Right\r\n"); 
                    myledDown = 1;
                    myledRight = 1;
                    break;
                case 0x1a: 
                    printf("0x1a\r\n"); 
                    break;
                case 0x1b: 
                    printf("0x1b Down\r\n"); 
                    myledDown = 1;
                    break;
                case 0x1c: 
                    printf("0x1c\r\n"); 
                    break;
                case 0x1d: 
                    printf("0x1d Right\r\n"); 
                    myledRight = 1;
                    break;
                case 0x1e: 
                    printf("0x1e Click\r\n"); 
                    myledLeft = 1;
                    myledUp = 1;
                    myledDown = 1;
                    myledRight = 1;
                    break;
                case 0x1f: 
                    printf("0x1f Nothing pressed\r\n"); 
                    break;
            }
        }
    }
}
