#include "mbed.h"

//
//This is based on my BinaryLEDDisplay
//It is my first go at using DigitalOut on pins rather than Mbed's own LEDs
//The 4 External LEDS count in binary from 0 to 15
//Each LED is connected to it's own pin and to pin1 (ground)
//
DigitalOut myled1(p5);
DigitalOut myled2(p6);
DigitalOut myled3(p7);
DigitalOut myled4(p8);
Timer mytimer;

int main() 
{
    myled1 = 1;
    myled2 = 1;
    myled3 = 1;
    myled4 = 1;
    mytimer.start();
    
    int intStart = mytimer.read_ms();
    int intCounter = 0;    
    bool blnSetalloff = true;
    while(1) 
    {
        if((mytimer.read_ms() - intStart) >= 250)
        {
            if (blnSetalloff)
            {
                myled1 = 0;
                myled2 = 0;
                myled3 = 0;
                myled4 = 0;
                blnSetalloff = false;
                continue;
            }

            if (intCounter % 16 > 7)
            {
                myled1 = 1;
            }
            if (intCounter % 8 > 3)
            {
                myled2 = 1;
            }
            if (intCounter % 4 > 1)
            {
                myled3 = 1;
            }
            if (intCounter % 2 == 1)
            {
                myled4 = 1;
            }
            intCounter +=1;
            blnSetalloff = true;
            intStart = mytimer.read_ms();
        }
    }
}