#include "mbed.h"
#include"TextLCD.h"

DigitalOut redLED(PC_10);
DigitalOut greenLED(PC_12);

DigitalIn startButton(PC_13);//user button
InterruptIn stopButton(PA_13);//external button

TextLCD lcd(PA_0,PA_1,PA_4,PB_0,PC_1,PC_0);


Timer randomNumberTimer;
Timer timerOfReaction;


Ticker timeCheck;

Serial pc(USBTX,USBRX);// for debuging

AnalogIn aIn(PC_3);

unsigned int random_generator (void)
{
    unsigned int x = 0;
    unsigned int iRandom = 0;
    for (x = 0; x <= 32; x += 2) {
        iRandom += ((aIn.read_u16() % 3) << x);
        wait_us (10);
    }

    if(iRandom < 0) {
        iRandom *= -1;
    }

    while(iRandom > 5000) {
        iRandom /= 100;
    }
//pc.printf("\n%d", iRandom);
    return iRandom;
}

int randomNumber = 0;
int toEarly = 0;

void checkTime()
{
    if(stopButton == 0)toEarly = -1;

    if(toEarly == 0) {
        if(randomNumberTimer.read_ms() >= randomNumber) {
            timeCheck.detach();
            redLED = 0;
            greenLED = 1;
            timerOfReaction.reset();
            timerOfReaction.start();
        }
    }
}

int timeOfReaction_ = -1;



void stopMeasure()
{

    redLED = 0;
    greenLED = 0;
    timeOfReaction_ = timerOfReaction.read_ms();
    timerOfReaction.stop();


}


int main()
{
lcd.cls();
    lcd.printf("Press user");
    lcd.locate(0,1);
    lcd.printf("button to start!");

    wait(1.5);
    lcd.cls();
    lcd.printf("Press external");
    lcd.locate(0,1);
    lcd.printf("button when     ");

    wait(1.5);
    lcd.cls();
    lcd.printf("green LED");
    lcd.locate(0,1);
    lcd.printf("is ON           ");

    wait(1.5);
    lcd.cls();
    lcd.printf("Waiting for the ");
    lcd.locate(0,1);
    lcd.printf("     START      ");
    
    startButton.mode(PullUp);
    stopButton.mode(PullUp);

    stopButton.fall(&stopMeasure);


    int oldInfo;

    

    while (true) {

        if(startButton == 0) {
            toEarly = 0;
            redLED = 1;
            greenLED = 0;
            randomNumber = random_generator();
            randomNumberTimer.reset();
            randomNumberTimer.start();
            timeCheck.attach(&checkTime,0.001);
        }


        if(timeOfReaction_ != -1 && timeOfReaction_ != oldInfo) {
            lcd.cls();
            lcd.printf("Time of reaction");
            lcd.locate(0,1);
            lcd.printf("is %d mS",timeOfReaction_);
            oldInfo = timeOfReaction_;
        }

        if(toEarly == -1) {
            toEarly = -2;
            lcd.cls();
            lcd.printf("Time of reaction");
            lcd.locate(0,1);
            lcd.printf("is to early !");
            wait(1.5);
            lcd.cls();
            lcd.printf("Waiting for the ");
            lcd.locate(0,1);
            lcd.printf("     START      ");

        }



    }
}

