/* LCDPanel base library for LCD/TFT Panels
 * Copyright (c) 2012, Silvio Gissi
 * 
 * License:
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * Author: Silvio Gissi
 * Version: 0.1 Alfa
 * References:
 * 	Based on demo code from iTeadStudio (www.iteadstudio.com) for
 * 	ITDB02-2.2SP. License unknown.
 * 
 * Known modules:
 * 	ITDB02-2.2SP (www.iteadstudio.com)
*/

#ifndef LCDPANEL_HX8340B_H
#define LCDPANEL_HX8340B_H

#include "LCDPanel_SPI.h"

#define LCDPANEL_HX8340B_HEIGHT 220
#define LCDPANEL_HX8340B_WIDTH  176

class LCDPanel_HX8340B : public LCDPanel_SPI {
    public:
        LCDPanel_HX8340B(PinName spi_data, PinName spi_clock, PinName cs, PinName rst);
    protected:
        virtual void window(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2);

};

#endif // LCDPANEL_HX8340B_H