/* LCDPanel base library for LCD/TFT Panels
 * Copyright (c) 2012, Silvio Gissi */

#include "LCDPanel_HX8340B.h"

LCDPanel_HX8340B::LCDPanel_HX8340B(PinName spi_data, PinName spi_clock, PinName cs, PinName rst) 
    : LCDPanel_SPI (LCDPANEL_HX8340B_WIDTH,LCDPANEL_HX8340B_HEIGHT,cs,
	spi_data, spi_clock, rst, 9, 1000000
    )
{
    // Reset
    _rst = 0;
    wait_ms(5);
    _rst = 1;
    wait_ms(5);
    CsTransaction(this);
    this->command(0xc1,3,0xff,0x83,0x40);
    this->command(0x11);
    wait_ms(10);
    this->command(0xca,5,0x70,0x00,0xD9,0x01,0x11);
    this->command(0xc9,8,0x90,0x49,0x10,0x28,0x28,0x10,0x00,0x06);
    wait_ms(20);
    this->command(0xc2,9,0x60,0x71,0x01,0x0e,0x05,0x02,0x09,0x31,0x0A);
    this->command(0xc3,8,0x67,0x30,0x61,0x17,0x48,0x07,0x05,0x33); 
    wait_ms(10);
    this->command(0xb5,3,0x35,0x20,0x45); 
    this->command(0xb4,3,0x33,0x25,0x4c); 
    wait_ms(10);
    this->command(0x3a,1,0x05);
    this->command(0x29); 
    wait_ms(10);
    clear();
}

void LCDPanel_HX8340B::window(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2) {
    // Set X window, panel size is less than 255, high byte always 0x00
    this->command(0x2a,4,0x00,x1,0x00,x2); 
    this->command(0x2b,4,0x00,y1,0x00,y2);    
    this->command(0x2c);
}

