#ifndef shell__h__
#define shell__h__

#include "PushButtons.h"
#define ItsInputBufferSize_ 24

class Shell {
public:
    Shell(uint32_t);
    void sendStartMessage();
    void scanUSBSerialRx();
    void reportPushButtonPress(ePushButton);
private:
    bool addCharacterToBuffer(char);
    void finishCharacterBuffer();
    void sendExample();
    char lowercase(char);
    void sendText(char *);
    void parseGenerate();
    void parseGet();
    void generatePi();
    void sendDecimal(uint8_t);

    Serial *usbSerial;
    char inputBuffer[ItsInputBufferSize_];
    uint16_t characterCount, characterPointer, decimalCounter;
    bool findString(char *);
    void parseCommands();
    void parseLEDState();
};

#endif