#include "mbed.h"
#include "shell.h"
#include "LEDColors.h"
#include "PushButtons.h"

Ticker *scanTicker;
Shell *usbSerialShell;
LEDColors *ledColors;
PushButtons *pushButtons;

bool at10msTickFlag;

void pushButtonPressed()
{
    // continuous signals
    if(pushButtons->getPressed(pb2)) ledColors->flash(lcBlue, 2);    
    if(pushButtons->getPressed(pb3)) ledColors->flash(lcGreen, 2);
    
    // momentary signals
    if(pushButtons->getJustPressed(pb2)) usbSerialShell->reportPushButtonPress(pb2);
    if(pushButtons->getJustPressed(pb3)) usbSerialShell->reportPushButtonPress(pb3);
}
//-----------------------------------------------------------------------------

void at10msTick()
{
    at10msTickFlag = true;
}
//-----------------------------------------------------------------------------

void initMain()
{
    // increase the baud rate for the USB serial port
    usbSerialShell = new Shell(115200);
    
    // send greeting with first cursor
    usbSerialShell->sendStartMessage();
    
    // start polling for characters
    scanTicker = new Ticker();
    scanTicker->attach(&at10msTick, 0.01);
    at10msTickFlag = false;
    
    ledColors = new LEDColors();
    pushButtons = new PushButtons();
}
//-----------------------------------------------------------------------------

int main() {
    initMain();
    
    while(true) {
        
        // check the flag 
        if(at10msTickFlag) {
            usbSerialShell->scanUSBSerialRx();
            ledColors->tick10ms();
            if(pushButtons->tick10ms()) pushButtonPressed();
        }
        at10msTickFlag = false;
        
        // give the main loop some time
        // wait(0.001);
    }
}
//-----------------------------------------------------------------------------
