#ifndef pushbuttons_h__
#define pushbuttons_h__

typedef enum {pb2 = 0, pb3} ePushButton;

class PushButtons {
public:
    PushButtons();
    bool tick10ms();
    bool getJustPressed(ePushButton);
    bool getPressed(ePushButton);
private:
    void reset(ePushButton);
    void process(ePushButton);
    DigitalIn *getPointer(ePushButton);

    DigitalIn *sw2, *sw3;
    uint32_t timer[2];
    bool justPressed[2], oldPressed[2];
};

#endif