#include "mbed.h"
#include "PushButtons.h"

PushButtons::PushButtons()
{
    // construct instances for push buttons
    sw2 = new DigitalIn(SW2);
    sw3 = new DigitalIn(SW3);
    
    // reset push buttons
    reset(pb2);
    reset(pb3);
}
//-----------------------------------------------------------------------------

bool PushButtons::tick10ms()
{
    // process push button metadata
    process(pb2);
    process(pb3);
    
    return !*sw2 || !*sw3;
}
//-----------------------------------------------------------------------------

void PushButtons::reset(ePushButton thisPushButton)
{
    // initiate push button
    timer[thisPushButton] = 0;
    justPressed[thisPushButton] = false;
    oldPressed[thisPushButton] = false;
}
//-----------------------------------------------------------------------------

void PushButtons::process(ePushButton thisPushButton)
{
    // check if the push button is pressed
    bool isPressed = !*getPointer(thisPushButton);
    
    // update debounce timer
    if(timer[thisPushButton]) timer[thisPushButton]--;
    
    // if not in debounce mode
    else if(isPressed) {
        
        // "just pressed" is set only once
        if(!oldPressed[thisPushButton]) justPressed[thisPushButton] = true;
        timer[thisPushButton] = 5;
    }
    
    // remember old state
    oldPressed[thisPushButton] = isPressed;
}
//-----------------------------------------------------------------------------

DigitalIn *PushButtons::getPointer(ePushButton thisPushButton)
{
    DigitalIn *thisPointer = 0;
    switch(thisPushButton) {
        case pb2: thisPointer = sw2; break;
        case pb3: thisPointer = sw3; break;
    }
    
    // return pointer to requested push button
    return thisPointer;
}
//-----------------------------------------------------------------------------

bool PushButtons::getJustPressed(ePushButton thisPushButton)
{
    // return state, and then reset
    bool isJustPressed = justPressed[thisPushButton];
    justPressed[thisPushButton] = false;
    return isJustPressed;
}
//-----------------------------------------------------------------------------

bool PushButtons::getPressed(ePushButton thisPushButton)
{
    // see if push button is momentary pressed
    return *getPointer(thisPushButton);
}
//-----------------------------------------------------------------------------
