#ifndef ledcolors__h__
#define ledcolors__h__

typedef enum {lcRed, lcBlue, lcGreen, lcNone, lcWhite} eLEDColor;
typedef enum {stNone = 0, stOn, stOff} eState;

class LEDColors {
public:
    LEDColors();
    void tick10ms();
    void flash(eLEDColor, uint32_t);
    void turn(eLEDColor, eState);
    eState getState(eLEDColor);
private:
    DigitalOut *getLEDPtr(eLEDColor);

    DigitalOut *ledRed, *ledBlue, *ledGreen;
    uint32_t timer[3];
    bool isOn[3];
};

#endif