#include "mbed.h"
#include "LEDColors.h"

// constructor
LEDColors::LEDColors()
{
    // DigitalOut ledRed(LED_RED), ledBlue(LED_BLUE), ledGreen(LED_GREEN);
    ledRed = new DigitalOut(LED_RED);
    ledBlue = new DigitalOut(LED_BLUE);
    ledGreen = new DigitalOut(LED_GREEN);

    // turn all three LEDs off
    *ledRed = true;
    timer[lcRed] = 0;
    isOn[lcRed] = false;
    
    *ledBlue = true;
    timer[lcBlue] = 0;
    isOn[lcBlue] = false;
    
    *ledGreen = true;
    timer[lcGreen] = 0;
    isOn[lcGreen] = false;
}
//-----------------------------------------------------------------------------

DigitalOut *LEDColors::getLEDPtr(eLEDColor thisLEDColor)
{
    DigitalOut *thisPtr = 0;
    
    switch(thisLEDColor) {
        case lcRed: thisPtr = ledRed; break;
        case lcBlue: thisPtr = ledBlue; break;
        case lcGreen: thisPtr = ledGreen; break;
    }
    
    return thisPtr;
}
//-----------------------------------------------------------------------------

void LEDColors::flash(eLEDColor thisLEDColor, uint32_t duration)
{
    *getLEDPtr(thisLEDColor) = false;
    timer[thisLEDColor] = duration;
}
//-----------------------------------------------------------------------------

void LEDColors::turn(eLEDColor thisLEDColor, eState thisState)
{
    bool thisOn = (thisState == stOn);
    isOn[thisLEDColor] = thisOn;
    *getLEDPtr(thisLEDColor) = !thisOn; 
}
//-----------------------------------------------------------------------------

void LEDColors::tick10ms()
{
    if(timer[lcRed] && !--timer[lcRed]) *ledRed = !isOn[lcRed];
    if(timer[lcBlue] && !--timer[lcBlue]) *ledBlue = !isOn[lcBlue];
    if(timer[lcGreen] && !--timer[lcGreen]) *ledGreen = !isOn[lcGreen];
}
//-----------------------------------------------------------------------------

eState LEDColors::getState(eLEDColor thisLEDColor)
{
    return isOn[thisLEDColor] ? stOn : stOff;
}
//-----------------------------------------------------------------------------