#pragma once

#include "mbed.h"
#include "PCA9547.h"
#include "vl6180x.h"
#include "datatypes.h"

/*enum DistanceSensor{
    FRONT,
    FRONT_RIGHT,
    RIGHT,
    BACK_RIGHT,
    BACK,
    BACK_LEFT,
    LEFT,
    FRONT_LEFT
}; */

class VL6180xManager
{
public:
    VL6180xManager(I2C &i2c);
    VL6180xManager(PinName sda, PinName scl);
    void select(int index);
    m3dpi::Distance getAllDistance();
    int getDistance(int index);

protected:

/*    enum DistanceSensor {
        FRONT,
        FRONT_RIGHT,
        RIGHT,
        BACK_RIGHT,
        BACK,
        BACK_LEFT,
        LEFT,
        FRONT_LEFT
    };*/
    
    void initialize();
    PCA9547 mux;
    I2C i2c;
    int address;
    VL6180x sensor;

    static const int SENSOR_COUNT = 8;
    static const int VL6180X_ADDRESS = 0x52;
};