#include "LedRing.h"

LedRing::LedRing(I2C &i2c) : driver1(i2c, DRIVER_1_ADDRESS), driver2(i2c, DRIVER_2_ADDRESS)
{
    initialize();
}

LedRing::LedRing(PinName sda, PinName scl): driver1(sda, scl, DRIVER_1_ADDRESS), driver2(sda, scl, DRIVER_2_ADDRESS)
{
    initialize();
}

void LedRing::initialize()
{
    driver1.enable();
    driver2.enable();
    
    setBrightness(0.05);
}

void LedRing::setColor(int led, Color* color)
{
    led--; // zero indexed from now on
    led = led % 8;
    
    int channelMap[8] = {0, 3, 6, 0, 3, 6, 9, 9};
    int driverMap[8]  = {1, 1, 1, 2, 2, 2, 2, 1};
    
    TLC59116* driver = (driverMap[led] == 1) ? &driver1 : &driver2;
    int startChannel = channelMap[led];
        
    setLed(driver, startChannel, color);
}

void LedRing::setColor(int led, int color)
{
    Color* _color = new Color(color);
    setColor(led, _color);
    delete _color;
}

void LedRing::setAll(Color* color)
{
    for(int i = 0; i < 8; i++){
        setColor(i+1, color);
    }
}

void LedRing::setAll(int color)
{
    Color* _color = new Color(color);
    setAll(_color);
    delete _color;
}

void LedRing::setAll(int* colors)
{
    for(int i = 0; i < 8; i++){
        setColor(i+1, colors[i]);
    }
}

void LedRing::setLed(TLC59116* driver, int startChannel, Color* color)
{
    driver->setChannel(startChannel + 0, color->getRed() / 255.0);
    driver->setChannel(startChannel + 1, color->getGreen() / 255.0);
    driver->setChannel(startChannel + 2, color->getBlue() / 255.0);    
}

void LedRing::setBrightness(float brightness)
{
    driver1.setBrightness(brightness);
    driver2.setBrightness(brightness);
}

void LedRing::greenRedGradient(int led, int value)
{
    Color* _color = new Color(255 - value, value, 0);
    setColor(led, _color);
    delete _color;
}
