
#include "M3Dpi.h"

M3Dpi::M3Dpi() :
    i2c(SDA,SCL),
    status(STATUS_RED,STATUS_GREEN,STATUS_BLUE),
    compass(i2c),
    gyro(i2c),
    accelerometer(i2c),
    leds(i2c),
    distance(i2c),
    xbee(XBEE_TX, XBEE_RX, XBEE_RESET)
{
    
    i2c.frequency(100000);   
    
    xbee.baud(XBEE_BAUD);
    xbee.reset();
    
    gyro.setLpBandwidth(LPFBW_42HZ);

    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);
    wait(.001);
    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);
    wait(.001);
    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);
    wait(.001);
    //Measurement mode.
    accelerometer.setPowerControl(0x08);
    wait(.001);
}

void M3Dpi::setStatus(Color* color)
{
    status.setColor(color);
}

void M3Dpi::setStatus(int color)
{
    status.setColor(color);
}


void M3Dpi::setLeds(int* colors)
{
    leds.setAll(colors);
}

m3dpi::Distance M3Dpi::getDistance()
{
    return distance.getAllDistance();
}

m3dpi::Direction M3Dpi::getDirection()
{
    m3dpi::Direction direction;
    coord c;
    c = compass.getCompass();
    direction.x = c.x;
    direction.y = c.y;
    direction.z = c.z;
    return direction;
}

m3dpi::Rotation M3Dpi::getRotation()
{
    m3dpi::Rotation rotation;
    rotation.x = gyro.getGyroX();
    rotation.y = gyro.getGyroY();
    rotation.z = gyro.getGyroZ();
    return rotation;
}

m3dpi::Acceleration M3Dpi::getAcceleration()
{
    m3dpi::Acceleration acc;
    int values[3] = {0};
    accelerometer.getOutput(values);
    acc.x = (int16_t) values[0];
    acc.y = (int16_t) values[1];
    acc.z = (int16_t) values[2];
    return acc;
}

int M3Dpi::_putc(int c)
{
    return xbee.putc(c);
}

int M3Dpi::_getc()
{
    return xbee.getc();
}

time_t M3Dpi::getTime()
{
    return time(NULL);
}