#include "vl6180xManager.h"

VL6180xManager::VL6180xManager(I2C &_i2c): mux(_i2c), i2c(_i2c), sensor(i2c)
{
    initialize();
}

VL6180xManager::VL6180xManager(PinName sda, PinName scl) : mux(sda, scl), i2c(sda, scl), sensor(sda, scl)
{
    i2c.frequency(400000);   
    initialize();
}

void VL6180xManager::initialize()
{  
    for(int i = 0; i < SENSOR_COUNT; i++) {
        select(i);
        sensor.initialize();
        sensor.startContinuousOperation();
    }
}

void VL6180xManager::select(int index)
{
    mux.select(index);
}

m3dpi::Distance VL6180xManager::getAllDistance()
{
    m3dpi::Distance distance;
    distance.front          = getDistance(0);
    distance.front_right    = getDistance(1);
    distance.right          = getDistance(2);
    distance.back_right     = getDistance(3);
    distance.back           = getDistance(4);
    distance.back_left      = getDistance(5);
    distance.left           = getDistance(6);
    distance.front_left     = getDistance(7);
    return distance;
}

int VL6180xManager::getDistance(int index)
{
    mux.select(index);
    return sensor.getDistance();
}


